Scriptname WitcherMeditateWaitQuestScript extends Quest  

actor property playerref auto
ObjectReference Property BedRef Auto Hidden
WitcherMeditateWaitQuestAliasScript property PlayerMediteteState auto
WitcherMeditateWaitMCMQuestScript property MCMScript auto
furniture property WitcherOwnBed auto
bool Meditatestart
ImageSpaceModifier 	Property FadeOut 			Auto
ImageSpaceModifier 	Property BlackScreen 		Auto
ImageSpaceModifier 	Property FadeIn 			Auto

Event OnInit()
	GoToState ("NormalState")
EndEvent



State NormalState



Event OnKeyDown(Int KeyCode)	
	if keycode == MCMScript.MeditateHotKey
		if	playerref.IsWeaponDrawn() == false && playerref.IsInCombat() == false && playerref.IsRunning() == false && \ 
			playerref.IsOnMount() == false && playerref.IsSwimming() == 0 && playerref.IsSprinting() == 0 && playerref.IsTrespassing() == false \
			&& playerref.GetFlyingState() == 0 && Game.IsActivateControlsEnabled() == true && PlayerMediteteState == true && Utility.IsInMenuMode() == false  \
			&& Game.IsCamSwitchControlsEnabled() == true && Game.IsMenuControlsEnabled() == true && Game.IsFightingControlsEnabled() == true && playerref.GetSitState() == 0\
			&& Game.IsJournalControlsEnabled() == true && Game.IsMovementControlsEnabled() == true && (game.GetCameraState() == 0 || game.GetCameraState() == 8 || game.GetCameraState() == 9)
			;Conditions need to enter meditation
			
			game.ForceThirdPerson()					;have to toggle to third person otherwise the animation won't run
			game.DisablePlayerControls(true, true, true, false, true, true, false, true, 0)
			
			If MCMScript.Issleep == true			;Check if the sleep mode toggle in MCMScript
				GoToState ("SleepState")
			Else
				If MCMScript.Issouls == false
					GoToState ("MeditateState")
				else
					GoToState ("SoulsMeditateState")
				endif	
			Endif	
		elseif	Utility.IsInMenuMode() == false && playerref.IsInCombat() == true
			Debug.Notification("$You can't Meditate in Combat.")		
		elseif	Utility.IsInMenuMode() == false && playerref.IsOnMount() == True
			Debug.Notification("$You can't Meditate while Riding.")	
		elseif	Utility.IsInMenuMode() == false && playerref.GetSitState() != 0
			Debug.Notification("$You can't Meditate while Sitting.")	
		elseif	Utility.IsInMenuMode() == false && playerref.IsWeaponDrawn() == true
			Debug.Notification("$You can't Meditate while Weapon Drawn.")			
		elseif	Utility.IsInMenuMode() == false 	
			Debug.Notification("$You can't Meditate now.") 
		endif
		; Tips about why you can't meditate
	endif
endevent


	

EndState

State MeditateState

Event OnBeginState()	
		RegisterForMenu("Sleep/Wait Menu") 
		Debug.SendAnimationEvent(playerref, "WMW_meditateenter")
		RegisterForSingleUpdate(3.5)
		Utility.Wait(2.2)
		
		if playerref.GetSitState() == 3 || playerref.GetSitState() == 4
			Input.TapKey(Input.GetMappedKey("Wait")) 		; if player success to sit, tap the wait key. otherwise, cancel the meditate
		else 
			Debug.Notification("$Fail to enter meditation")
			GoToState("NormalState")
		endif
endevent

Event OnUpdate()
		Debug.trace("WMW_UpdateStart")
		Debug.SendAnimationEvent(playerref, "IdleChairExitStart")
		GoToState("NormalState") 		
endevent

Event OnMenuOpen(String MenuName)
	If MenuName == "Sleep/Wait Menu"
	endif
endevent	



Event OnEndState()
	UnRegisterForMenu("Sleep/Wait Menu")
	game.EnablePlayerControls()	
endevent

EndState	
		
State SleepState

Event OnBeginState()
		Meditatestart = true
		RegisterForMenu("Sleep/Wait Menu") 
		Debug.SendAnimationEvent(playerref, "WMW_meditateenter")
		RegisterForSingleUpdate(6.0)
		Utility.Wait(2.2)
		
		if playerref.GetSitState() == 3 || playerref.GetSitState() == 4
			BedRef = playerref.PlaceAtMe(WitcherOwnBed, 1)
			FadeOut.Apply()
			Utility.Wait(2.5) ; since Fadeout lasts exactly 3.0s, we need to allow some script delay
			FadeOut.PopTo(BlackScreen)
			Debug.SendAnimationEvent(playerref, "IdleForceDefaultState")
					
			Utility.Wait(0.3)
			BedRef.Activate(playerref, true)
		else 
			Debug.Notification("$Fail to enter meditation")
			GoToState("NormalState")
		endif
endevent

Event OnUpdate()
	if Meditatestart == true
		Debug.trace("WMW_UpdateStart")
		BedRef.delete()
		BlackScreen.PopTo(FadeIn)
		Debug.SendAnimationEvent(playerref, "IdleChairExitStart")
		GoToState("NormalState")
	else 
		Debug.trace("WMW_UpdateFail")	
	endif	
endevent

Event OnMenuOpen(String MenuName)
	If MenuName == "Sleep/Wait Menu"
		Meditatestart = false	
	endif
endevent	





Event OnMenuClose(String MenuName)
	If MenuName == "Sleep/Wait Menu"
		BedRef.delete()
		Utility.Wait(0.3)
		Debug.SendAnimationEvent(playerref, "WMW_meditateidle1")
		Utility.Wait(2.0)
		BlackScreen.PopTo(FadeIn)
		Utility.Wait(1.5)
		Debug.SendAnimationEvent(playerref, "IdleChairExitStart")		
		GoToState("NormalState")
	endif
endevent

Event OnEndState()
	UnRegisterForMenu("Sleep/Wait Menu")
	Meditatestart = false	
	game.EnablePlayerControls()	
endevent

EndState	

State SoulsMeditateState

Event OnBeginState()	
		Debug.Notification("SoulsMeditateState") 
		Meditatestart = true
		RegisterForMenu("Sleep/Wait Menu") 
		Debug.SendAnimationEvent(playerref, "WMW_meditateenter")
		RegisterForSingleUpdate(3.5)
		Utility.Wait(2.2)
		
		if playerref.GetSitState() == 3 || playerref.GetSitState() == 4
			Input.TapKey(Input.GetMappedKey("Wait")) 		; if player success to sit, tap the wait key. otherwise, cancel the meditate
		else 
			Debug.Notification("$Fail to enter meditation")
			GoToState("NormalState")
		endif
endevent

Event OnUpdate()
	if	Meditatestart == true
		Debug.trace("WMW_UpdateStart")
		Debug.SendAnimationEvent(playerref, "IdleChairExitStart")
		GoToState("NormalState")
	else
		Debug.trace("WMW_UpdateFail")
	endif		
endevent

Event OnMenuOpen(String MenuName)
	If MenuName == "Sleep/Wait Menu"
		Meditatestart = false
	endif
endevent	

Event OnMenuClose(String MenuName)
	If MenuName == "Sleep/Wait Menu"
		Utility.Wait(1.0)
		Debug.SendAnimationEvent(playerref, "IdleChairExitStart")
		GoToState("NormalState")
	endif
endevent 		


Event OnEndState()
	UnRegisterForMenu("Sleep/Wait Menu")
	Meditatestart = false
	game.EnablePlayerControls()	
endevent

EndState
	